//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;
var gIsVideoStart = 0;
var SrcLayoutDef = -1;
var SrcLayoutFmt = -1;
var SrcPosiArray = [];
var CamConnArray = [];

function initWebSocketVideo() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageSettings("GetVideoIsStartStreaming");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageVideo("GetVideoOutputSetting");      
        sendMessageVideo("GetCameraList"); 
        sendMessageIndex("CheckDanteActiveDataIsExport");        
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageSettings("GetVideoIsStartStreaming");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageVideo("GetVideoOutputSetting");      
        sendMessageVideo("GetCameraList"); 
        sendMessageIndex("CheckDanteActiveDataIsExport");        
    });

    websocket.addEventListener('message',function(evt){
        //console.log('Message received',evt.data);
        if(evt.data instanceof Blob)
        {

        }
        else
        {
            //console.log('Message received');
            receivedDataVideo(evt.data);
        }
    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };


}

function receivedDataVideo(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);

    //console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply) {

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;

        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        case "GetVideoOutputSetting":
            updatedLayoutInfo(obj);
            updatedVideoOutputSetting(obj);
            break;

        case "GetCameraList":
            updatedConnectedList(obj);
            updatedLayoutPosition();
            break;

        case "StartVideoStreaming":
            updatedStartVideoStreaming(obj,true);
            break;

        case "StopVideoStreaming":
            updatedStopVideoStreaming(obj);
            break;

        case "SetVideoOutputSetting":
            updatedSetVideoOutputSetting(obj);
            break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            break;

        case "LoadProfile":
            //console.log('LoadProfile!!');
            if("Status" in obj)
            {
                console.log('LoadPorfile Status:',obj.Status);
                if(obj.Status.includes("Finished"))
                {
                    sendMessageVideo("GetCurrentProfileID");
                    UnblockUIforPage();
                }
            }
            break;

        case "SearchCamera":
            sendMessageVideo("GetCurrentProfileID");
            UnblockUIforPage();
            break;

        case "GetVideoIsStartStreaming":
            gIsVideoStart = getVideoStreamingStatus(obj);
            if(gIsVideoStart)
            {
                if(document.getElementById("Div_VideoOutputSettingMenu"))
                    document.getElementById("Div_VideoOutputSettingMenu").style.display = "block";
                if(document.getElementById("videoOutputModeSelect"))
                    document.getElementById("videoOutputModeSelect").disabled = true;
            }
            else
            {
                if(document.getElementById("Div_VideoOutputSettingMenu"))
                    document.getElementById("Div_VideoOutputSettingMenu").style.display = "block";
                if(document.getElementById("videoOutputModeSelect"))
                    document.getElementById("videoOutputModeSelect").disabled = false;
            }
            break;
        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
            break;
    }

}

function updatedSetVideoOutputSetting(msg) {

    if(msg.Reset == true){
        UnblockUIforPage();
        sendMessageVideo("GetVideoOutputSetting");   
        sendMessageVideo("GetCameraList");     
    }
}

function updatedStartVideoStreaming(msg, isVdeoSettingPage) {
    if (msg.Result == true) {
        //if ($("#Div_LeftVideoOutputSetting").attr('id') === getCurrObjID()) {
        //    sendMessageVideo("GetVideoOutputSetting");
         //   sendMessageVideo("GetCameraList")
        //}
        disabledLeftMenu();
        if (isVdeoSettingPage && document.getElementById("Label_VideoOutputSetting")) 
        {
            document.getElementById("Div_VideoOutputSettingMenu").style.display = "block";
            document.getElementById("videoOutputModeSelect").disabled = true;
            document.getElementById("seamlessSwitchingCheckboxInput").disabled = false;
            console.log('OutputMode', getSelectorValue("videoOutputModeSelect"));
            console.log('SeamlessSwitching', getCheckboxState("seamlessSwitchingCheckboxInput"));
        }
        // document.getElementById("videoOnOffButton").innerHTML = "Stop Video Output";
    }

    window.LanguageManager.InitLanguageOfPage();

    document.getElementById("videoOnOffButton").disabled = true;

    setTimeout(function () {
        document.getElementById("videoOnOffButton").disabled = false;
        UnblockUIforPage();
        if (isVdeoSettingPage)
        {
            if ($("#Div_LeftVideoOutputSetting").attr('id') === getCurrObjID()) {
                sendMessageVideo("GetVideoOutputSetting");
                sendMessageVideo("GetCameraList")
            }
        }
       
    }, 5000);
}

function updatedStopVideoStreaming(msg) {

        if(msg.Result == true){
            enabledLeftMenu();
            if(document.getElementById("Label_VideoOutputSetting")){
            document.getElementById("Div_VideoOutputSettingMenu").style.display = "block";
            document.getElementById("videoOutputModeSelect").disabled = false;
            document.getElementById("seamlessSwitchingCheckboxInput").disabled = false;
            // document.getElementById("CrossCheckboxInput").disabled = false;
            // document.getElementById("PBPCheckboxInput").disabled = false;
            /* if(document.getElementById("PBPCheckboxInput").checked == true)
                document.getElementById("CropCheckboxInput").disabled = true;
            else
                document.getElementById("CropCheckboxInput").disabled = false; */
            //---- New UI ----//
            document.getElementById("layoutTypeSelect").disabled = false;
            if (document.getElementById("layoutTypeSelect").value == 0)
                document.getElementById("layoutCrossCropCheckboxInput").disabled = false;
            else
                document.getElementById("layoutCrossCropCheckboxInput").disabled = true;
            if (getCheckboxState("seamlessSwitchingCheckboxInput") === true) {
                disableSrcPosiLayout(true);
            }
            else {
            document.getElementById("srcPositionSelect").disabled = false;
            srcPositionSelector();
            }
            changeSettingApplyCancelStatus(true);
            //---- New UI ----//
            }
            //document.getElementById("videoOnOffButton").innerHTML = "Start Video Output";
            window.LanguageManager.InitLanguageOfPage();
            // document.getElementById("Select_Profile").disabled = false;
        }

        setTimeout(function () {
            UnblockUIforPage();
            document.getElementById("videoOnOffButton").disabled = false;
        }, 5000);

}

function updatedVideoOutputSetting(msg) {

    console.log('msg.OutputFormat:',msg.OutputFormat);
    console.log('msg.SwitchingMode:',msg.SwitchingMode);
    
   
    document.getElementById("videoOnOffButton").disabled = false;

    //if(msg.IsStartStreaming == true)//video Streaming Enable?
        //document.getElementById("videoStreamingEnableCheckboxInput").checked = true;
    //else
        //document.getElementById("videoStreamingEnableCheckboxInput").checked = false;
    if(msg.IsStartStreaming == true)//video Streaming Enable?
        gIsVideoStart = 1;
    else
        gIsVideoStart = 0;

    var outputModeSelec = document.getElementById("videoOutputModeSelect");
        $("#videoOutputModeSelect option").remove();
        //let versionArr = gVersion.split(".");
        //let version1 = parseInt(versionArr[0]);
        //let version2 = parseInt(versionArr[1]);
        if(gUseNewRender)
        {
            var option = new Option("HDMI" , 1);
            outputModeSelec.appendChild(option);
            option = new Option("UVC+HDMI" , 2);
            outputModeSelec.appendChild(option);
            option = new Option("RTSP+HDMI" , 3);
            outputModeSelec.appendChild(option);

            //Output Mode            
            if(msg.OutputFormat == 1)
                $("#videoOutputModeSelect").val(1);//HDMI
            else if(msg.OutputFormat == 0 || msg.OutputFormat == 2 )
                $("#videoOutputModeSelect").val(2);//UVC+HDMI
            else 
                $("#videoOutputModeSelect").val(3);//RTSP+HDMI
        }
        else
        {
            var option = new Option("UVC" , 0);
            outputModeSelec.appendChild(option);
            option = new Option("HDMI" , 1);
            outputModeSelec.appendChild(option);
            option = new Option("UVC+HDMI" , 2);
            outputModeSelec.appendChild(option);

            //Output Mode
            if(msg.OutputFormat == 0)
                $("#videoOutputModeSelect").val(0);
            else if(msg.OutputFormat == 1)
                $("#videoOutputModeSelect").val(1);//HDMI
            else if(msg.OutputFormat == 2 )
                $("#videoOutputModeSelect").val(2);//UVC+HDMI           
            
        }
        

    //Switching mode
    if(msg.SwitchingMode == 0)
        document.getElementById("seamlessSwitchingCheckboxInput").checked = true;
    else
        document.getElementById("seamlessSwitchingCheckboxInput").checked = false;

    //Output Layput
    if(msg.OutputLayout == 0){
        // document.getElementById("CrossCheckboxInput").checked = true;
        // document.getElementById("PBPCheckboxInput").checked = false;
        // document.getElementById("CropCheckboxInput").disabled = false;
        //IsCropCrop
        /* if(msg.IsCrop == true)
            document.getElementById("CropCheckboxInput").checked = true;
        else
            document.getElementById("CropCheckboxInput").checked = false; */
        $("#layoutTypeSelect").val(0);
        document.getElementById("layoutCrossCropCheckboxInput").disabled = false;
        if(msg.IsCrop == true)
            document.getElementById("layoutCrossCropCheckboxInput").checked = true;
        else
            document.getElementById("layoutCrossCropCheckboxInput").checked = false;
    }
    else{
        // document.getElementById("CrossCheckboxInput").checked = false;
        // document.getElementById("PBPCheckboxInput").checked = true;
        // document.getElementById("CropCheckboxInput").disabled = true;
        // document.getElementById("CropCheckboxInput").checked = false;
        $("#layoutTypeSelect").val(1);
        document.getElementById("layoutCrossCropCheckboxInput").disabled = true;
    }
/*
    //IsCropCrop
    if(msg.IsCrop == true)
        document.getElementById("CropCheckboxInput").checked = true;
    else
        document.getElementById("CropCheckboxInput").checked = false;
*/
    //SwitchingMode turn on ----> layout setting hide
    if (getCheckboxState("seamlessSwitchingCheckboxInput") === true)
        document.getElementById("Div_ouputlayout").style.display = "none";
    else{
        document.getElementById("Div_ouputlayout").style.display = "block";
        if(gIsVideoStart == 1){
            // document.getElementById("CrossCheckboxInput").disabled = true;
            // document.getElementById("PBPCheckboxInput").disabled = true;
            // document.getElementById("CropCheckboxInput").disabled = true;
        }
        else{
            // document.getElementById("CrossCheckboxInput").disabled = false;
            // document.getElementById("PBPCheckboxInput").disabled = false;
//            document.getElementById("CropCheckboxInput").disabled = false;
        }
    }

    //video Streaming Enable ----> Hide all setting
    //if(document.getElementById("videoStreamingEnableCheckboxInput").checked == true){
        //document.getElementById("Div_VideoOutputSettingMenu").style.display = "none";
        //disabledLeftMenu();
    //}
    //else{
        //document.getElementById("Div_VideoOutputSettingMenu").style.display = "block";
        //enabledLeftMenu();
   //}
    if(gIsVideoStart == 1){
        document.getElementById("videoOutputModeSelect").disabled = true;
/*
        document.getElementById("seamlessSwitchingCheckboxInput").disabled = true;
        //---- New UI ----//
        document.getElementById("layoutTypeSelect").disabled = true;
        document.getElementById("layoutCrossCropCheckboxInput").disabled = true;
        document.getElementById("srcPositionSelect").disabled = true;
        //---- New UI ----//
*/
        //---- SWT-35127 ----//
        document.getElementById("seamlessSwitchingCheckboxInput").disabled = false;
        document.getElementById("layoutTypeSelect").disabled = false;
        document.getElementById("layoutCrossCropCheckboxInput").disabled = (getSelectorValue("layoutTypeSelect") !== 0);
        document.getElementById("srcPositionSelect").disabled = false;
        //---- SWT-35127 ----//
        document.getElementById("videoOnOffButton").innerHTML = "Stop Video Output";
        window.LanguageManager.InitLanguageOfPage();
        disabledLeftMenu();
    }
    else{
        document.getElementById("videoOutputModeSelect").disabled = false;
        document.getElementById("seamlessSwitchingCheckboxInput").disabled = false;
        //---- New UI ----//
        document.getElementById("layoutTypeSelect").disabled = false;
        document.getElementById("layoutCrossCropCheckboxInput").disabled = (getSelectorValue("layoutTypeSelect") !== 0);
        document.getElementById("srcPositionSelect").disabled = false;
        //---- New UI ----//
        //document.getElementById("videoOnOffButton").innerHTML = "Start Video Output";
        window.LanguageManager.InitLanguageOfPage();
        enabledLeftMenu();
    }
    changeSettingApplyCancelStatus(true);

}

function sendMessageVideo(cmd,data) {

    var msg = cmd;


    if ( websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "SetVideoOutputSetting"){
/*
            jsonmsg.IsCrop =  document.getElementById("CropCheckboxInput").checked? true:false;
            jsonmsg.OutputFormat  = parseInt(document.getElementById("videoOutputModeSelect").value, 10);
            jsonmsg.OutputLayout =  document.getElementById("PBPCheckboxInput").checked?1:0;//0:cross 1:PBP
            jsonmsg.SwitchingMode =  document.getElementById("seamlessSwitchingCheckboxInput").checked? 0:1;
*/
            jsonmsg.IsCrop = document.getElementById("layoutCrossCropCheckboxInput").checked? true:false;
            jsonmsg.OutputFormat  = parseInt(document.getElementById("videoOutputModeSelect").value, 10);
            jsonmsg.OutputLayout  = parseInt(document.getElementById("layoutTypeSelect").value, 10);
            jsonmsg.SwitchingMode = document.getElementById("seamlessSwitchingCheckboxInput").checked? 0:1;
            jsonmsg.SourceLayoutDefine = getSelectorValue("srcPositionSelect");
            jsonmsg.SourceLayoutFormat = getLayoutFormatValue() ;//getSelectorValue("layoutFormatSelect");
            var tmp_data = [];
            for (var i = 1; i < 5; i++) {
                var rowData = {};
                rowData[ "Position" ] = i;
                rowData[ "Camera" ] = getSelectorText("layoutCamPos" + i);
                tmp_data.push(rowData);
            }
            jsonmsg.SourcePositionArray = tmp_data;
            console.log( "SetVideoOutputSetting sent :", JSON.stringify(jsonmsg) );
        }      
        if (websocket.readyState == 1) {
        websocket.send( JSON.stringify(jsonmsg) );
        //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

function onChangeVideoOutputSettingApplyStatus() {
    changeSettingApplyCancelStatus(false);
}

function changeSettingApplyCancelStatus(status) {
    document.getElementById("applyVideoOutputSettingButton").disabled = status;
    document.getElementById("cancelVideoOutputSettingButton").disabled = status;
}

function enableApplyVideoOutputSettingButton(){
    document.getElementById("applyVideoOutputSettingButton").disabled = false;
}

function enableCancelVideoOutputSettingButton(){
    document.getElementById("cancelVideoOutputSettingButton").disabled = false;
}

function videoOutputSettingApply(){

    sendMessageVideo("SetVideoOutputSetting");
    blockUIforPage();
}

function videoOutputSettingCancel(){
    console.log('Cancel all unsaved settings...');
    sendMessageVideo("GetVideoOutputSetting");  
    sendMessageVideo("GetCameraList");  
}

function onClickVideoOnOffButton()
{
    if(gIsVideoStart == 1)
    {
        document.getElementById("videoOnOffButton").innerHTML = "Start Video Output";
        document.getElementById("videoOnOffButton").disabled = true;
        sendMessageVideo("StopVideoStreaming");

        window.LanguageManager.InitLanguageOfPage();
        blockUIforPage();
        gIsVideoStart = 0;
    }
    else
    {
        document.getElementById("videoOnOffButton").innerHTML = "Stop Video Output";
        document.getElementById("videoOnOffButton").disabled = true;
        if ((document.getElementById("applyVideoOutputSettingButton") !== null) &&
            (document.getElementById("applyVideoOutputSettingButton").disabled !== true)) 
        {
            sendMessageVideo("SetVideoOutputSetting");
        }

        sendMessageVideo("StartVideoStreaming");
        window.LanguageManager.InitLanguageOfPage();
        blockUIforPage();
        gIsVideoStart = 1;
    }
}

function changeVideoSwitchingMode(e){
    //SwitchingMode turn on ----> layout setting hide
    if (e.checked) {
        document.getElementById("Div_ouputlayout").style.display = "none";
        disableSrcPosiLayout(true);
    }
    else {
        document.getElementById("Div_ouputlayout").style.display = "block";
        document.getElementById("srcPositionSelect").disabled = false;
        updatedLayoutPosition();
    }
    enableApplyVideoOutputSettingButton();
    enableCancelVideoOutputSettingButton();
}

/*function changeCross(e){

    if(e.checked){
        document.getElementById("PBPCheckboxInput").checked = false;
        document.getElementById("CropCheckboxInput").disabled = false;
    }
    else{
        document.getElementById("PBPCheckboxInput").checked = true;
        document.getElementById("CropCheckboxInput").disabled = true;
    }
    enableApplyVideoOutputSettingButton();
    enableCancelVideoOutputSettingButton();
}*/

/*function changePBP(e){

    if(e.checked){
        document.getElementById("CrossCheckboxInput").checked = false;
//        document.getElementById("cropTd").style.display = "none";
        document.getElementById("CropCheckboxInput").disabled = true;
    }
    else{
        document.getElementById("CrossCheckboxInput").checked = true;
//        document.getElementById("cropTd").style.display = "block";
        document.getElementById("CropCheckboxInput").disabled = false;
    }
    enableApplyVideoOutputSettingButton();
    enableCancelVideoOutputSettingButton();
}*/

function layoutTypeSelector() {
    var layoutType = document.getElementById("layoutTypeSelect").value;
    if (layoutType == 0) {
        document.getElementById("layoutCrossCropCheckboxInput").disabled = false;
    }
    else {
        document.getElementById("layoutCrossCropCheckboxInput").disabled = true;
        document.getElementById("layoutCrossCropCheckboxInput").checked = false;
    }
    onChangeVideoOutputSettingApplyStatus();
}

function updatedLayoutInfo(msg) {
    SrcLayoutDef = msg.SourceLayoutDefine;
    SrcLayoutFmt = msg.SourceLayoutFormat;
    if (msg.SourcePositionArray.length == 0)
        return;
    var i = 0;
    let size = SrcPosiArray.length;
    for (i = 0; i < size; i++)
        SrcPosiArray.pop();
    for (var idx = 0; idx < 4; idx++) {
        var rowData = {};
        rowData[ "Camera" ] = msg.SourcePositionArray[idx].Camera;
        rowData[ "Position" ] = msg.SourcePositionArray[idx].Position;
        SrcPosiArray.push(rowData);
    }
    console.log(SrcLayoutDef, SrcLayoutFmt, SrcPosiArray.length);
}

function isElmEnabled(elmId) {
    return (document.getElementById(elmId).disabled !== true);
}

function getCheckboxState(elmId) {
    var cbox = document.getElementById(elmId);
    if(cbox)
    {
        return cbox.checked;
    }
}

function getSelectorValue(elmId) {
    var selector = document.getElementById(elmId);
    var option = selector.options[selector.selectedIndex].value;
    if(option)
    {
        return parseInt(option, 10);
    }
//    console.log(elmId, option);

}

function getSelectorText(elmId) {
    var selector = document.getElementById(elmId);
    
    if(selector.options[selector.selectedIndex].text)
    {
        if(elmId.indexOf('layoutCamPos') >= 0 || elmId.indexOf('PipCameraPosOption') >= 0)
        {
            let size = CamConnArray.length;
            for (idx = 0; idx < size; idx++)
            {
                if(selector.options[selector.selectedIndex].text == CamConnArray[idx].DisplayName)
                    return option = CamConnArray[idx].Camera;
            }
            return option = selector.options[selector.selectedIndex].text;
        }        
        else
            return option = selector.options[selector.selectedIndex].text;
    }
    else
        return option = window.LanguageManager.getTranslatedText("Off");
}

function updatedConnectedList(msg) {
    console.log("updatedConnectedList:", msg);
    var camConnCnt = 0;
    var idx = 0;
    let size = CamConnArray.length;
    for (idx = 0; idx < size; idx++)
        CamConnArray.pop();
    for (idx = 0; idx < msg.CameraCount; idx++) {
        if (msg.CamerasArray[idx].IsConnect == "1") {
            camConnCnt++;
            var rowData = {};
            rowData[ "Camera" ] = msg.CamerasArray[idx].IPAddress;
            rowData[ "Position" ] = (camConnCnt).toString()
            rowData[ "DisplayName" ] = msg.CamerasArray[idx].DisplayName;
            CamConnArray.push(rowData);
        }
    }
}

function disableSrcPosiLayout(state) {
    document.getElementById("srcPositionSelect").disabled = state;
    //document.getElementById("layoutFormatSelect").disabled = state;
    document.getElementById("layoutFormat1x1").disabled = state;
    document.getElementById("layoutFormat1x2").disabled = state;
    document.getElementById("layoutFormat1x3").disabled = state;
    document.getElementById("layoutFormat1x4_2x2").disabled = state;
    document.getElementById("layoutCamPos1").disabled = state;
    document.getElementById("layoutCamPos2").disabled = state;
    document.getElementById("layoutCamPos3").disabled = state;
    document.getElementById("layoutCamPos4").disabled = state;
}

function updatedLayoutFormat(value) 
{
    var radio1x1 = document.getElementById("layoutFormat1x1");
    var radio1x2 = document.getElementById("layoutFormat1x2");
    var radio1x3 = document.getElementById("layoutFormat1x3");
    var radio2x2 = document.getElementById("layoutFormat1x4_2x2");

    if (SrcLayoutFmt == 2)
    {
        if(radio2x2)
            radio2x2.checked = true;
    }
    else if (SrcLayoutFmt == 1)
    {
        if(radio1x2)
            radio1x2.checked = true;
    }
    else if (SrcLayoutFmt == 3)
    {
        if(radio1x3)
            radio1x3.checked = true;
    }
    else
    {
        if(radio1x1)
            radio1x1.checked = true;
    }

}

function updatedLayoutPosition() {
//    console.log('Cam Connected Array :', CamConnArray);
//    console.log('Custom Define Array :', SrcPosiArray);

    /* if (document.getElementById("seamlessSwitchingCheckboxInput").checked == true) {
        disableSrcPosiLayout(true);
        return;
    } */

    if (SrcLayoutDef == 1)
        $("#srcPositionSelect").val(1);
    else
        $("#srcPositionSelect").val(0);

    /*if (SrcLayoutFmt == 2)
        $("#layoutFormatSelect").val(2);
    else if (SrcLayoutFmt == 1)
        $("#layoutFormatSelect").val(1);
    else if (SrcLayoutFmt == 3)
        $("#layoutFormatSelect").val(3);
    else
        $("#layoutFormatSelect").val(0);
    */
        updatedLayoutFormat(SrcLayoutFmt);

    for (i = 1; i < 5; i++) 
    {
        $("#layoutCamPos" + i + " option").remove();
    }

    for (i = 1; i < 5; i++) 
    {
        var selector = document.getElementById("layoutCamPos" + i);
        var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
        if(selector)
            selector.appendChild(option);
        var currentValue = 0;
        for (j = 0; j < CamConnArray.length; j++) 
        {
            option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
//                    console.log(i, option.value, option.text);
            selector.appendChild(option);

            if(i <= SrcPosiArray.length)
            {
                if(CamConnArray[j].Camera === SrcPosiArray[i-1].Camera )
                {
                    currentValue = j + 1;
                }
            }
        }
        $("#layoutCamPos" + i).val(currentValue);


    }
    
    /*
    if (SrcLayoutDef == 1) 
    {
        if (SrcPosiArray.length == 0 && CamConnArray.length == 0) {
            for (i = 1; i < 5; i++) {
                var selector = document.getElementById("layoutCamPos" + i);
                var option = new Option('Off' , 0);
                selector.appendChild(option);
            }
            for (var i = 1; i < 5; i++) {
                $("#layoutCamPos" + i).val(0);
            }
        }
        else if (SrcPosiArray.length < CamConnArray.length) {
            for (i = 1; i < 5; i++) {
                var selector = document.getElementById("layoutCamPos" + i);
                var option = new Option('Off' , 0);
                selector.appendChild(option);
                for (j = 0; j < CamConnArray.length; j++) {
                    option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
//                    console.log(i, option.value, option.text);
                    selector.appendChild(option);
                }
            }
            for (var i = 1; i < 5; i++) {
                $("#layoutCamPos" + i).val(0);
            }
        }
        else if (SrcPosiArray.length > CamConnArray.length) {
            for (i = 1; i < 5; i++) {
                var selector = document.getElementById("layoutCamPos" + i);
                var option = new Option('Off' , 0);
                selector.appendChild(option);
                for (j = 0; j < SrcPosiArray.length; j++) {
                    option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(SrcPosiArray[j].Camera , j + 1);
//                    console.log(i, option.value, option.text);
                    selector.appendChild(option);
                }
            }
            for (var i = 1; i < 5; i++) {
                $("#layoutCamPos" + i).val(i);
            }
        }
        else {
            for (i = 1; i < 5; i++) {
                var selector = document.getElementById("layoutCamPos" + i);
                var option = new Option('Off' , 0);
                selector.appendChild(option);
                for (j = 0; j < SrcPosiArray.length; j++) {
                    option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(SrcPosiArray[j].Camera , j + 1);
//                    console.log(i, option.value, option.text);
                    selector.appendChild(option);
                }
            }
            for (var i = 1; i < 5; i++) {
                $("#layoutCamPos" + i).val(i);
            }
        }
    }
    else 
    {
        for (i = 1; i < 5; i++) {
            var selector = document.getElementById("layoutCamPos" + i);
            var optCA = new Option('Off' , 0);
            selector.appendChild(optCA);
            for (j = 0; j < CamConnArray.length; j++) {
                optCA = new Option(CamConnArray[j].DisplayName , j + 1);//optCA = new Option(CamConnArray[j].Camera , j + 1);
//                console.log(i, optCA.value, optCA.text);
                selector.appendChild(optCA);
            }
        }
        for (var i = 1; i < 5; i++) {
            $("#layoutCamPos" + i).val(0);
        }
    }
    */
    srcPositionSelector();
    changeSettingApplyCancelStatus(true);
    UnblockUIforPage();
}

function srcPositionSelector() {
    if (gIsVideoStart == 1) {
            document.getElementById("seamlessSwitchingCheckboxInput").disabled = false;
            if (getCheckboxState("seamlessSwitchingCheckboxInput") === true) {
                disableSrcPosiLayout(true);
            }
            else {
                document.getElementById("layoutTypeSelect").disabled = false;
                if (getSelectorValue("layoutTypeSelect") === 0)
                    document.getElementById("layoutCrossCropCheckboxInput").disabled = false;
                else
                    document.getElementById("layoutCrossCropCheckboxInput").disabled = true;
                document.getElementById("srcPositionSelect").disabled = false;
                if (getSelectorValue("srcPositionSelect") === 0) {
                    //document.getElementById("layoutFormatSelect").disabled = true;
                    document.getElementById("layoutFormat1x1").disabled = true;
                    document.getElementById("layoutFormat1x2").disabled = true;
                    document.getElementById("layoutFormat1x3").disabled = true;
                    document.getElementById("layoutFormat1x4_2x2").disabled = true;
                    disableLayoutCamPosX();
                }
                else {
                    //document.getElementById("layoutFormatSelect").disabled = false;
                    document.getElementById("layoutFormat1x1").disabled = false;
                    document.getElementById("layoutFormat1x2").disabled = false;
                    document.getElementById("layoutFormat1x3").disabled = false;
                    document.getElementById("layoutFormat1x4_2x2").disabled = false;
                    layoutFormatSelector();
                }
            }
    }
    else {
        if (getCheckboxState("seamlessSwitchingCheckboxInput") === true) {
            disableSrcPosiLayout(true);
            return;
        }
        var selValue = getSelectorValue("srcPositionSelect");
        if (selValue == 0) {
            //document.getElementById("layoutFormatSelect").disabled = true;
            document.getElementById("layoutFormat1x1").disabled = true;
            document.getElementById("layoutFormat1x2").disabled = true;
            document.getElementById("layoutFormat1x3").disabled = true;
            document.getElementById("layoutFormat1x4_2x2").disabled = true;
            disableLayoutCamPosX();
        }
        else {
            //document.getElementById("layoutFormatSelect").disabled = false;
            document.getElementById("layoutFormat1x1").disabled = false;
            document.getElementById("layoutFormat1x2").disabled = false;
            document.getElementById("layoutFormat1x3").disabled = false;
            document.getElementById("layoutFormat1x4_2x2").disabled = false;
            layoutFormatSelector();
        }
    }
}

function disableLayoutCamPosX() {
    document.getElementById("layoutCamPos1").disabled = true;
    document.getElementById("layoutCamPos2").disabled = true;
    document.getElementById("layoutCamPos3").disabled = true;
    document.getElementById("layoutCamPos4").disabled = true;
    onChangeVideoOutputSettingApplyStatus();
}

function getLayoutFormatValue() {
    var radio1x1 = document.getElementById("layoutFormat1x1");
    var radio1x2 = document.getElementById("layoutFormat1x2");
    var radio1x3 = document.getElementById("layoutFormat1x3");
    var radio2x2 = document.getElementById("layoutFormat1x4_2x2");

    var option =2;
    if(radio1x1.checked)
        option =0;
    else if(radio1x2.checked)
        option =1;
    else if(radio1x3.checked)
         option =3;
    else if(radio2x2.checked)
         option =2;

    return parseInt(option, 10);
}

function layoutFormatSelector() {
    var selValue = getLayoutFormatValue();//getSelectorValue("layoutFormatSelect");
    if (selValue == 0) {
        document.getElementById("layoutCamPos1").disabled = false;
        document.getElementById("layoutCamPos2").disabled = true;
        document.getElementById("layoutCamPos3").disabled = true;
        document.getElementById("layoutCamPos4").disabled = true;
    }
    else if (selValue == 1) {
        document.getElementById("layoutCamPos1").disabled = false;
        document.getElementById("layoutCamPos2").disabled = false;
        document.getElementById("layoutCamPos3").disabled = true;
        document.getElementById("layoutCamPos4").disabled = true;
    }
    else if (selValue == 2){
        document.getElementById("layoutCamPos1").disabled = false;
        document.getElementById("layoutCamPos2").disabled = false;
        document.getElementById("layoutCamPos3").disabled = false;
        document.getElementById("layoutCamPos4").disabled = false;
    }
    else if (selValue == 3) {
        document.getElementById("layoutCamPos1").disabled = false;
        document.getElementById("layoutCamPos2").disabled = false;
        document.getElementById("layoutCamPos3").disabled = false;
        document.getElementById("layoutCamPos4").disabled = true;
    }
    onChangeVideoOutputSettingApplyStatus();
}

function layoutCamPos1() {
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 5; i++) {
        selElm = document.getElementById("layoutCamPos" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
//    console.log('layoutCamPos', CamPosit);
    if (isElmEnabled("layoutCamPos2") && (CamPosit[1] == CamPosit[0]))
        $("#layoutCamPos2").val(0);
    if (isElmEnabled("layoutCamPos3") && (CamPosit[2] == CamPosit[0]))
        $("#layoutCamPos3").val(0);
    if (isElmEnabled("layoutCamPos4") && (CamPosit[3] == CamPosit[0]))
        $("#layoutCamPos4").val(0);
    changeSettingApplyCancelStatus(false);
}

function layoutCamPos2() {
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 5; i++) {
        selElm = document.getElementById("layoutCamPos" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
    if (CamPosit[0] == CamPosit[1])
        $("#layoutCamPos1").val(0);
    if (isElmEnabled("layoutCamPos3") && (CamPosit[2] == CamPosit[1]))
        $("#layoutCamPos3").val(0);
    if (isElmEnabled("layoutCamPos4") && (CamPosit[3] == CamPosit[1]))
        $("#layoutCamPos4").val(0);
    changeSettingApplyCancelStatus(false);
}

function layoutCamPos3() {
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 5; i++) {
        selElm = document.getElementById("layoutCamPos" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
    if (CamPosit[0] == CamPosit[2])
        $("#layoutCamPos1").val(0);
    if (CamPosit[1] == CamPosit[2])
        $("#layoutCamPos2").val(0);
    if (CamPosit[3] == CamPosit[2])
        $("#layoutCamPos4").val(0);
    changeSettingApplyCancelStatus(false);
}

function layoutCamPos4() {
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 5; i++) {
        selElm = document.getElementById("layoutCamPos" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
    if (CamPosit[0] == CamPosit[3])
        $("#layoutCamPos1").val(0);
    if (CamPosit[1] == CamPosit[3])
        $("#layoutCamPos2").val(0);
    if (CamPosit[2] == CamPosit[3])
        $("#layoutCamPos3").val(0);
    changeSettingApplyCancelStatus(false);
}

function openVideoOutputSetting() {

    $("#DivMainPage").load("./page/videosetting.html", function () {
        
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        initWebSocketVideo();

/*
        document.getElementById("seamlessSwitchingCheckboxInput").onchange = function() {onChangeVideoOutputSettingApplyStatus();};
        document.getElementById("CrossCheckboxInput").onchange             = function() {onChangeVideoOutputSettingApplyStatus();};
        document.getElementById("PBPCheckboxInput").onchange               = function() {onChangeVideoOutputSettingApplyStatus();};
*/
        // document.getElementById("CropCheckboxInput").onchange              = function() {onChangeVideoOutputSettingApplyStatus();};
        document.getElementById("videoOutputModeSelect").onchange          = function() {onChangeVideoOutputSettingApplyStatus();};
        document.getElementById("Select_Profile").style.display = "block";
        document.getElementById("Label_Profile").style.display = "block";
        document.getElementById("layoutCrossCropCheckboxInput").onchange   = function() {onChangeVideoOutputSettingApplyStatus();};

        if(document.getElementById("layoutCamPos1"))
        {
            document.getElementById("layoutCamPos1").addEventListener("mouseout", onMouseoutCameraItem);
            document.getElementById("layoutCamPos1").addEventListener("mouseover", onMouseoverCameraItem);
        }
        if(document.getElementById("layoutCamPos2"))
        {
            document.getElementById("layoutCamPos2").addEventListener("mouseout", onMouseoutCameraItem);
            document.getElementById("layoutCamPos2").addEventListener("mouseover", onMouseoverCameraItem);
        }
        if(document.getElementById("layoutCamPos3"))
        {
            document.getElementById("layoutCamPos3").addEventListener("mouseout", onMouseoutCameraItem);
            document.getElementById("layoutCamPos3").addEventListener("mouseover", onMouseoverCameraItem);
        }
        if(document.getElementById("layoutCamPos4"))
        {
            document.getElementById("layoutCamPos4").addEventListener("mouseout", onMouseoutCameraItem);
            document.getElementById("layoutCamPos4").addEventListener("mouseover", onMouseoverCameraItem);
        }

        $( "#layoutCamPos1" ).click(function() {
            var selector = document.getElementById("layoutCamPos1");
            var clickOpt = selector.options[selector.selectedIndex].value;
            $("#layoutCamPos1 option").remove();
            var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
            selector.appendChild(option);
            for (j = 0; j < CamConnArray.length; j++) {
                option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
                selector.appendChild(option);
            }
            console.log('#layoutCamPos1', clickOpt);
            $("#layoutCamPos1").val(clickOpt);
            $('#layoutCamPos1').trigger('change');
        });

        $( "#layoutCamPos2" ).click(function() {
            var selector = document.getElementById("layoutCamPos2");
            var clickOpt = selector.options[selector.selectedIndex].value;
            $("#layoutCamPos2 option").remove();
            var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
            selector.appendChild(option);
            for (j = 0; j < CamConnArray.length; j++) {
                option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
                selector.appendChild(option);
            }
            console.log('#layoutCamPos2', clickOpt);
            $("#layoutCamPos2").val(clickOpt);
            $('#layoutCamPos2').trigger('change');
        });

        $( "#layoutCamPos3" ).click(function() {
            var selector = document.getElementById("layoutCamPos3");
            var clickOpt = selector.options[selector.selectedIndex].value;
            $("#layoutCamPos3 option").remove();
            var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
            selector.appendChild(option);
            for (j = 0; j < CamConnArray.length; j++) {
                option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
                selector.appendChild(option);
            }
            console.log('#layoutCamPos3', clickOpt);
            $("#layoutCamPos3").val(clickOpt);
            $('#layoutCamPos3').trigger('change');
        });

        $( "#layoutCamPos4" ).click(function() {
            var selector = document.getElementById("layoutCamPos4");
            var clickOpt = selector.options[selector.selectedIndex].value;
            $("#layoutCamPos4 option").remove();
            var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
            selector.appendChild(option);
            for (j = 0; j < CamConnArray.length; j++) {
                option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
                selector.appendChild(option);
            }
            console.log('#layoutCamPos4', clickOpt);
            $("#layoutCamPos4").val(clickOpt);
            $('#layoutCamPos4').trigger('change');
        });

    });
}


